<?php

namespace App\Http\Controllers;

use App\Models\KYCDocument;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class KYCController extends Controller
{
    public function index(Request $request)
    {
        $companyId = Auth::user()->company_id;
        $kycs = KYCDocument::where('company_id', $companyId)->paginate(20);
        return view('kyc.index', compact('kycs'));
    }

    public function create()
    {
        return view('kyc.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'user_id' => 'required|exists:users,id',
            'document_type' => 'required|string',
            'document_file' => 'required|file|mimes:jpg,jpeg,png,pdf',
        ]);
        $data['company_id'] = Auth::user()->company_id;
        $data['status'] = 'pending';
        $data['document_file'] = $request->file('document_file')->store('kyc_docs');
        KYCDocument::create($data);
        return redirect()->route('kyc.index')->with('success', 'KYC document uploaded.');
    }

    public function edit(KYCDocument $kyc)
    {
        return view('kyc.edit', compact('kyc'));
    }

    public function update(Request $request, KYCDocument $kyc)
    {
        $data = $request->validate([
            'status' => 'required|string',
        ]);
        $kyc->update($data);
        return redirect()->route('kyc.index')->with('success', 'KYC status updated.');
    }

    public function destroy(KYCDocument $kyc)
    {
        Storage::delete($kyc->document_file);
        $kyc->delete();
        return redirect()->route('kyc.index')->with('success', 'KYC document deleted.');
    }
}
