<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class GDPRController extends Controller
{
    public function privacy()
    {
        return view('gdpr.privacy');
    }

    public function downloadData()
    {
        $user = Auth::user();
        $data = $user->toArray();
        $filename = 'user_data_' . $user->id . '.json';
        return response()->json($data)->header('Content-Disposition', 'attachment; filename=' . $filename);
    }

    public function deleteAccount(Request $request)
    {
        $user = Auth::user();
        $user->delete();
        return redirect('/')->with('success', 'Account deleted as per GDPR request.');
    }
}
