<?php

namespace App\Http\Controllers;

use App\Models\Franchise;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class FranchiseController extends Controller
{
    public function index()
    {
        $franchises = Franchise::all();
        return view('franchise.index', compact('franchises'));
    }

    public function create()
    {
        return view('franchise.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'required|string|unique:franchises,code',
            'email' => 'required|email|unique:franchises,email',
            'phone' => 'required|string',
        ]);
        Franchise::create($request->all());
        return redirect()->route('franchise.index')->with('success', 'Franchise created.');
    }

    public function edit($id)
    {
        $franchise = Franchise::findOrFail($id);
        return view('franchise.edit', compact('franchise'));
    }

    public function update(Request $request, $id)
    {
        $franchise = Franchise::findOrFail($id);
        $franchise->update($request->all());
        return redirect()->route('franchise.index')->with('success', 'Franchise updated.');
    }

    public function destroy($id)
    {
        $franchise = Franchise::findOrFail($id);
        $franchise->delete();
        return redirect()->route('franchise.index')->with('success', 'Franchise deleted.');
    }
}
