<?php

namespace App\Http\Controllers;

use App\Models\EPin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EPinController extends Controller
{
    public function index(Request $request)
    {
        $companyId = Auth::user()->company_id;
        $epins = EPin::where('company_id', $companyId)->paginate(20);
        return view('epin.index', compact('epins'));
    }

    public function create()
    {
        return view('epin.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'code' => 'required|unique:e_pins,code',
            'amount' => 'required|numeric',
            'expires_at' => 'nullable|date',
        ]);
        $data['company_id'] = Auth::user()->company_id;
        $data['status'] = 'active';
        EPin::create($data);
        return redirect()->route('epin.index')->with('success', 'EPin created.');
    }

    public function edit(EPin $epin)
    {
        return view('epin.edit', compact('epin'));
    }

    public function update(Request $request, EPin $epin)
    {
        $data = $request->validate([
            'amount' => 'required|numeric',
            'expires_at' => 'nullable|date',
            'status' => 'required|string',
        ]);
        $epin->update($data);
        return redirect()->route('epin.index')->with('success', 'EPin updated.');
    }

    public function destroy(EPin $epin)
    {
        $epin->delete();
        return redirect()->route('epin.index')->with('success', 'EPin deleted.');
    }
}
