<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Controller;
use App\Models\Wallet;
use App\Models\LedgerEntry;
use App\Models\User;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $wallets = Wallet::where('user_id', $user->id)->get();
        $ledger = LedgerEntry::where('user_id', $user->id)->orderByDesc('id')->limit(10)->get();
        $teamCount = User::where('sponsor_id', $user->id)->count();
        $stats = \Cache::remember('dashboard.stats.' . $user->id, 60, function() use ($user) {
            $binaryBV = (new \App\Services\BinaryBVService())->calculateBV($user);
            $repurchaseBV = (new \App\Services\RepurchaseBVService())->calculateRepurchaseBV($user);
            return [
                'orders' => $user->orders()->count(),
                'commission' => $user->commission,
                'epins' => $user->epins()->count(),
                'binary_bv' => $binaryBV,
                'repurchase_bv' => $repurchaseBV,
            ];
        });
        return view('dashboard.index', compact('stats', 'user', 'wallets', 'ledger', 'teamCount'));
    }
}
