<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\Product;
use App\Models\User;

class BulkImportExportController extends Controller
{
    public function show()
    {
        return view('bulk.import_export');
    }

    public function exportProducts()
    {
        $products = Product::all();
        $csv = "id,name,price,stock\n";
        foreach ($products as $p) {
            $csv .= "{$p->id},{$p->name},{$p->price},{$p->stock}\n";
        }
        $filename = 'products_export_' . date('Ymd_His') . '.csv';
        Storage::disk('local')->put($filename, $csv);
        return response()->download(storage_path('app/' . $filename))->deleteFileAfterSend(true);
    }

    public function importProducts(Request $request)
    {
        $request->validate(['file' => 'required|file|mimes:csv,txt']);
        $file = $request->file('file');
        $rows = array_map('str_getcsv', file($file->getRealPath()));
        $header = array_shift($rows);
        foreach ($rows as $row) {
            $data = array_combine($header, $row);
            Product::updateOrCreate(['id' => $data['id']], $data);
        }
        return redirect()->back()->with('status', 'Products imported successfully.');
    }

    public function exportUsers()
    {
        $users = User::all();
        $csv = "id,name,email,phone\n";
        foreach ($users as $u) {
            $csv .= "{$u->id},{$u->name},{$u->email},{$u->phone}\n";
        }
        $filename = 'users_export_' . date('Ymd_His') . '.csv';
        Storage::disk('local')->put($filename, $csv);
        return response()->download(storage_path('app/' . $filename))->deleteFileAfterSend(true);
    }

    public function importUsers(Request $request)
    {
        $request->validate(['file' => 'required|file|mimes:csv,txt']);
        $file = $request->file('file');
        $rows = array_map('str_getcsv', file($file->getRealPath()));
        $header = array_shift($rows);
        foreach ($rows as $row) {
            $data = array_combine($header, $row);
            User::updateOrCreate(['id' => $data['id']], $data);
        }
        return redirect()->back()->with('status', 'Users imported successfully.');
    }
}
