<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuditLogController extends Controller
{
    public function index(Request $request)
    {
        $companyId = Auth::user()->company_id;
        $logs = ActivityLog::where('company_id', $companyId)
            ->orderByDesc('created_at')
            ->paginate(50);
        return view('auditlog.index', compact('logs'));
    }
}
