<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\User;
use App\Models\Product;
use App\Models\Order;
use App\Models\WithdrawalRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminDashboardController extends Controller
{
    public function index()
    {
        $companyId = Auth::user()->company_id;
        $stats = [
            'users' => User::where('company_id', $companyId)->count(),
            'products' => Product::where('company_id', $companyId)->count(),
            'orders' => Order::where('company_id', $companyId)->count(),
            'withdrawals' => WithdrawalRequest::where('company_id', $companyId)->count(),
        ];
        $company = Company::find($companyId);
        return view('admin.dashboard', compact('stats', 'company'));
    }

    public function settings()
    {
        $companyId = Auth::user()->company_id;
        $company = Company::find($companyId);
        return view('admin.settings', compact('company'));
    }

    public function updateSettings(Request $request)
    {
        $companyId = Auth::user()->company_id;
        $company = Company::find($companyId);
        $data = $request->validate([
            'name' => 'required|string',
            'email' => 'required|email',
            'phone' => 'nullable|string',
            'address' => 'nullable|string',
        ]);
        $company->update($data);
        return redirect()->route('admin.settings')->with('success', 'Settings updated.');
    }
}
