<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\DailyClosing;
use App\Models\User;

class ProcessDailyClosing extends Command
{
    protected $signature = 'closing:daily';
    protected $description = 'Process daily closing for all companies';

    public function handle()
    {
        $companies = \App\Models\Company::all();
        foreach ($companies as $company) {
            $closing = DailyClosing::firstOrCreate([
                'company_id' => $company->id,
                'closing_date' => now()->toDateString(),
            ], [
                'status' => 'processing',
                'users_processed' => 0,
                'users_total' => 0,
                'started_at' => now(),
            ]);
            $users = User::where('company_id', $company->id)->where('status', 'active')->get();
            $closing->users_total = $users->count();
            foreach ($users as $user) {
                // Process user closing logic here
                $closing->users_processed++;
            }
            $closing->status = 'completed';
            $closing->completed_at = now();
            $closing->save();
        }
        $this->info('Daily closing processed.');
    }
}
