<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Services\Compensation\BinaryPlanService;
use App\Services\Compensation\UnilevelPlanService;
use App\Services\Compensation\MatrixPlanService;
use App\Services\Compensation\DirectIncomeService;

class ProcessCompensation extends Command
{
    protected $signature = 'compensation:process {date?}';
    protected $description = 'Process all compensation plans for all users';

    public function handle()
    {
        $date = $this->argument('date') ?? now()->toDateString();
        $users = User::where('status', 'active')->get();
        $binary = new BinaryPlanService();
        $unilevel = new UnilevelPlanService();
        $matrix = new MatrixPlanService();
        $direct = new DirectIncomeService();
        foreach ($users as $user) {
            $binary->processPairing($user, $date);
            $unilevel->processUnilevel($user, $date);
            $matrix->processMatrix($user, $date);
            $direct->processDirect($user, $date);
        }
        $this->info('Compensation processed for '.$users->count().' users.');
    }
}
